clc
clear
load("data_300.mat")
i =[3:1:7 8:2:20];
E = squeeze(Err(i,:,30))' 


options.marker = "-^"

options.color_line = [179, 63, 64]./255 ;
options.color_area = options.color_line + (1-options.color_line)*2.3/4 ;
options.x_axis = i;
plot_areaerrorbar(E,options)
xlabel("Number of Treatments (n)")
ylabel("Structural Hamming Distance (SHD)")
grid on

load("data_300_lgn.mat")
i =[3:1:7 8:2:20];
E = squeeze(Err(i,:,20))' 



options.marker = "-o"
options.color_line = [72, 161, 77]./255 ;
options.color_area = options.color_line + (1-options.color_line)*2.3/4 ;
options.x_axis = i;
plot_areaerrorbar(E,options)

xlabel("Number of Treatments (n)")
ylabel("Structural Hamming Distance (SHD)")
grid on


load("data_300_cnst.mat")
i =[3:1:7 8:2:20];
E = Err(i,:)' 


options.marker = "-square"
options.color_line = [01, 119, 179]./255 ;
options.color_area = options.color_line + (1-options.color_line)*2.3/4 ;
options.x_axis = i;
plot_areaerrorbar(E,options)

xlabel("Number of Treatments (n)")
ylabel("Structural Hamming Distance (SHD)")
grid on
xlim([3 20])
ylim([0 30])
box on

legend("","$d_{max}$ = $\mathcal{O}$(n)","","$d_{max}$ = $\mathcal{O}$(log(n))","","$d_{max}$ = $\mathcal{O}$(1)","Interpreter","latex")